package com.onsiteservice.admin.security;

import com.alibaba.fastjson.JSONObject;
import com.onsiteservice.admin.security.pojo.CustomUserDetails;
import com.onsiteservice.constant.constant.Constants;
import com.onsiteservice.core.security.jwt.JwtManager;
import com.onsiteservice.dao.mapper.sys.SysUserMapper;
import com.onsiteservice.entity.sys.SysUser;
import com.onsiteservice.util.ArrayUtils;
import com.onsiteservice.util.ReflectUtils;
import io.jsonwebtoken.Claims;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.stereotype.Service;
import org.springframework.util.AntPathMatcher;
import tk.mybatis.mapper.entity.Condition;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.*;


/**
 * 具体模块安全通用服务
 */
@Service
@Slf4j
public class SecurityService {

    @Resource
    private SysUserMapper sysUserMapper;
    @Resource
    private HttpServletRequest httpServletRequest;
    @Value("${project.jwt.ant-paths}")
    private String antPaths;

    /**
     * 根据用户名获取用户信息
     */
    public Object getUserByName(String userName) {
        Condition condition = new Condition(SysUser.class);
        condition.createCriteria().andEqualTo(JwtManager.USER_NAME, userName);
        return sysUserMapper.selectByCondition(condition).stream().findFirst().orElse(null);
    }



    /**
     * 验证权限资源列表中所有权限
     */
    public boolean verifyPermissions(HttpServletRequest request, List resourceList) {
        if (isIgnorePath(request.getRequestURI())) {
            return true;
        }
        String method;
        AntPathRequestMatcher matcher;
        if (resourceList != null) {
            for (Object item : resourceList) {
                String operatePath = ReflectUtils.invokeGetter(item, "operatePath");
                String operateMethod = ReflectUtils.invokeGetter(item, "operateMethod");
                matcher = new AntPathRequestMatcher(Constants.REQUEST_PREFIX + operatePath);
                method = operateMethod == null ? "ALL" : operateMethod.toUpperCase();
                if (matcher.matches(request)) {
                    //当权限表权限的method为ALL时表示拥有此路径的所有请求方式权利
                    if (method.equals(request.getMethod()) || "ALL".equals(method)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    /**
     * 判断请求资源是否时可忽略权限检查
     */
    private boolean isIgnorePath(String path) {
        if (antPaths != null) {
            for (String pattern : StringUtils.deleteWhitespace(antPaths).split(",")) {
                // Ant URL风格匹配
                AntPathMatcher antPathMatcher = new AntPathMatcher();
                if (antPathMatcher.match(pattern, path)) {
                    return true;
                }
                return false;
            }
        }
        return false;
    }

}
