package com.onsiteservice.admin.mapper.sys;


import com.onsiteservice.admin.controller.sys.dto.SysUserCaregiverPageDTO;
import com.onsiteservice.admin.controller.sys.dto.SysUserPageDTO;
import com.onsiteservice.entity.sys.SysUser;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author 王鑫
 * @date 2021-04-25 10:57
 * SysUserBizMapper业务接口
 */
public interface SysUserBizMapper {

    /**
     * 分页查询列表
     * @return
     */
    List<SysUser> getPage(@Param("param") SysUserPageDTO param);

    List<SysUser> getCaregiverPage(@Param("param") SysUserCaregiverPageDTO param);

    /**
     * 查询用户已关联的角色id集合
     */
    List<Long> selectRoleIdListByUser(@Param("userId") Long userId);

    /**
     * 删除用户的角色关联数据
     */
    int deleteUserRole(String userIds);

    /**
     * 插入用户与角色的关联数据
     */
    int setUserRole(@Param("userId") Long userId, @Param("roleIdList") List<Long> roleId);

    SysUser getDetail(Integer id);


    List<String> getRoleNameListByUserId(Long userId);

    int getRepeat(@Param(value = "userId")Long userId, @Param(value = "userName") String userName);



}
