package com.onsiteservice.admin.mapper.sys;


import com.github.pagehelper.Page;
import com.onsiteservice.admin.controller.sys.dto.SysDictPageDTO;
import com.onsiteservice.entity.sys.SysDict;
import com.onsiteservice.entity.sys.SysDictType;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author wang jianguo
 * @date 2021-07-23 10:37
 * SysDictTypeBizMapper业务接口
 */
public interface SysDictTypeBizMapper {

    /**
     * 获取分页列表
     *
     * @param param
     * @return com.github.pagehelper.Page<com.dao.model.sys.SysCodeType>
     * @author linxianghua
     * @date 2019/10/12 10:45
     */
    Page<SysDictType> getPage(@Param("param") SysDictPageDTO param);

    List<SysDict> getSysCodeDetailList(String code);

    /**
     * 查询重复
     *
     * @param id
     * @param code
     * @return int
     * @author linxianghua
     * @date 2019/10/14 17:10
     */
    int getRepeat(@Param("id") Long id, @Param("code") String code);

    void updateTypeCode(@Param("newCode") String newCode, @Param("oldCode") String oldCode);
}
