package com.onsiteservice.admin.listener;

import com.onsiteservice.common.socket.SocketHandler;
import com.onsiteservice.constant.constant.SysConstants;
import com.onsiteservice.service.order.dto.PayNoticeVO;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.data.util.Pair;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.TextMessage;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * 管理端事件通知
 */
@Component
@RabbitListener(queuesToDeclare = @Queue(SysConstants.Queue.ADMIN_ORDER))
public class OrderListener {

    @Resource
    private SocketHandler socketHandler;

    private static final String USER_ID = "id";
    // 1 用户已付款
    private static final String TYPE = "type";

    @RabbitHandler
    public void notice(PayNoticeVO param) {
        socketHandler.sendMessageToUser(param.getId(), new TextMessage(param.getType()));
    }

}
