package com.onsiteservice.admin.controller.sys;

import com.onsiteservice.admin.service.sys.SysDictService;
import com.onsiteservice.core.result.Result;
import com.onsiteservice.dao.common.page.PageInfoVO;
import com.onsiteservice.dao.common.page.PageParams;
import com.onsiteservice.entity.sys.SysDict;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.NonNull;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import javax.annotation.Resource;
import javax.validation.constraints.Positive;

import static com.onsiteservice.core.result.ResultGenerator.success;


/**
 * @author wang jianguo
 * @date 2021-07-23 10:37
 * SysDictController控制类
 */
@ApiIgnore
@Api(tags = "SysDictController")
@RestController
@RequestMapping("/sys/dict")
@Validated
public class SysDictController {

    @Resource
    private SysDictService sysDictService;


    @ApiOperation(value = "分页查询列表", notes = "作者: wang jianguo")
    @PostMapping("/page")
    public Result<PageInfoVO> getPage(@RequestBody @NonNull @Validated PageParams param) {
        return success(sysDictService.getPage(param), "获取分页列表");
    }

    @ApiOperation(value = "根据id查询", notes = "作者: wang jianguo")
    @GetMapping("/{id}")
    public Result<SysDict> getDetails(@PathVariable @Positive Long id) {
        return success(sysDictService.selectByPrimaryKey(id), "根据id获取详情");
    }

    @ApiOperation(value = "新增或修改", notes = "作者: wang jianguo")
    @PostMapping("/save-or-update")
    public Result saveOrUpdate(@RequestBody @NonNull @Validated SysDict sysDict) {
        return success(sysDictService.saveOrUpdate(sysDict), sysDict.getId() == null ? "新增成功" : "修改成功");
    }

    @ApiOperation(value = "根据id删除", notes = "作者: wang jianguo")
    @DeleteMapping("/{id}")
    public Result deleteById(@PathVariable @Positive Long id) {
        return success(sysDictService.deleteByPrimaryKey(id), "删除成功");
    }

}
