package com.onsiteservice.admin.controller.service;

import com.onsiteservice.admin.controller.service.dto.PageServiceWorkerDTO;
import com.onsiteservice.admin.controller.service.dto.SaveServiceWorkerDTO;
import com.onsiteservice.admin.controller.service.dto.UpdateServiceWorkerDTO;
import com.onsiteservice.admin.controller.service.vo.ServiceWorkerKindVO;
import com.onsiteservice.admin.controller.service.vo.ServiceWorkerVO;
import com.onsiteservice.admin.controller.service.vo.WorkerInfoVO;
import com.onsiteservice.admin.service.service.ServiceWorkerService;
import com.onsiteservice.common.annotation.user.CurrentUserId;
import com.onsiteservice.core.result.Result;
import com.onsiteservice.dao.common.page.PageInfoVO;
import com.onsiteservice.entity.service.ServiceWorker;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.NonNull;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import javax.annotation.Resource;
import javax.validation.constraints.Positive;

import java.util.List;

import static com.onsiteservice.core.result.ResultGenerator.fail;
import static com.onsiteservice.core.result.ResultGenerator.success;

/**
 * <P>维修工模块</P>
 *
 * @author 李宁
 * @version v1.0
 * @since 2022/7/11 08:51
 */
@Api(tags = "维修工模块")
@RestController
@RequestMapping("/worker/")
@Validated
public class ServiceWorkerController {

    @Resource
    private ServiceWorkerService serviceWorkerService;


    @ApiOperation(value = "分页查询列表")
    @PostMapping("page")
    public Result<PageInfoVO<ServiceWorkerVO>> getPage(@RequestBody @NonNull @Validated PageServiceWorkerDTO dto) {
        return serviceWorkerService.getPage(dto);
    }

    @ApiOperation(value = "根据id查询")
    @GetMapping("/{id}")
    public Result<ServiceWorkerVO> getDetails(@ApiParam(name = "id", value = "维修工id") @PathVariable @Positive Long id) {
        return success(serviceWorkerService.selectById(id));
    }

    @ApiOperation(value = "根据id查询")
    @GetMapping("search")
    public Result<List<WorkerInfoVO>> searchByName(@RequestParam(name = "name", required = false) String name) {
        return success(serviceWorkerService.selectByName(name));
    }

    @ApiOperation(value = "新增")
    @PostMapping("save")
    public Result save(@RequestBody @NonNull @Validated SaveServiceWorkerDTO dto, @CurrentUserId Long userId) {
        return serviceWorkerService.save(dto, userId) == 1 ? success() : fail("新增失败");
    }

    @ApiOperation(value = "修改")
    @PostMapping("update")
    public Result update(@RequestBody @NonNull @Validated UpdateServiceWorkerDTO dto, @CurrentUserId Long userId) {
        return serviceWorkerService.update(dto, userId) == 1 ? success() : fail("修改失败");
    }

    @ApiOperation(value = "根据id删除")
    @DeleteMapping("delete/{id}")
    public Result deleteById(@ApiParam(name = "id", value = "维修工id") @PathVariable @Positive Long id, @CurrentUserId Long userId) {
        return serviceWorkerService.delete(id, userId) == 1 ? success() : fail("删除失败");
    }

    @ApiIgnore
    @ApiOperation(value = "维修工种类")
    @GetMapping("kind")
    public Result<List<ServiceWorkerKindVO>> kind() {
        return success(serviceWorkerService.kind());
    }


}
