package com.onsiteservice.admin.controller.service;

import com.onsiteservice.admin.controller.service.dto.PageServiceValuatorDTO;
import com.onsiteservice.admin.controller.service.dto.SaveServiceValuatorDTO;
import com.onsiteservice.admin.controller.service.dto.UpdateServiceValuatorDTO;
import com.onsiteservice.admin.controller.service.vo.ServiceValuatorVO;
import com.onsiteservice.admin.service.service.ServiceValuatorService;
import com.onsiteservice.common.annotation.user.CurrentUserId;
import com.onsiteservice.core.result.Result;
import com.onsiteservice.dao.common.page.PageInfoVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.NonNull;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.validation.constraints.NotBlank;

import java.util.List;

import static com.onsiteservice.core.result.ResultGenerator.success;

/**
 * <P>估价员模块</P>
 *
 * @author 李宁
 * @version v1.0
 * @since 2022/7/11 08:51
 */
@Api(tags = "估价员模块")
@RestController
@RequestMapping("/valuator/")
@Validated
public class ServiceValuatorController {

    @Resource
    private ServiceValuatorService serviceValuatorService;


    @ApiOperation(value = "根据姓名查询")
    @GetMapping("search")
    public Result<List<ServiceValuatorVO>> getDetails(@RequestParam(name = "name", required = false) @ApiParam(name = "name", value = "估价员姓名") String name) {
        return success(serviceValuatorService.selectByName(name));
    }


}
