package com.onsiteservice.admin.controller.service;

import com.onsiteservice.admin.controller.service.dto.PromotePageDTO;
import com.onsiteservice.entity.service.ServicePromote;
import com.onsiteservice.admin.service.service.ServicePromoteService;

import com.onsiteservice.core.result.Result;
import com.onsiteservice.dao.common.page.PageInfoVO;
import com.onsiteservice.dao.common.page.PageParams;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.NonNull;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import javax.annotation.Resource;
import javax.validation.constraints.Positive;

import static com.onsiteservice.core.result.ResultGenerator.success;
import static com.onsiteservice.core.result.ResultGenerator.fail;

/**
 * @author 商天翔
 * @date 2022-07-21 15:55
 * @description ServicePromoteController控制类
 */
@ApiIgnore
@Api(tags = "ServicePromoteController")
@RestController
@RequestMapping("/service/promote")
@Validated
public class ServicePromoteController {

    @Resource
    private ServicePromoteService servicePromoteService;


    @ApiOperation(value = "分页查询列表", notes = "作者: 商天翔")
    @PostMapping("/page")
    public Result<PageInfoVO> getPage(@RequestBody @NonNull @Validated PromotePageDTO param) {
        return success(servicePromoteService.getPage(param), "获取分页列表");
    }

}
