package com.onsiteservice.admin.controller.order.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 订单分页VO
 */
@Data
public class OrderPageVO {

    private Long id;

    @ApiModelProperty("订单号")
    private String orderNo;

    @ApiModelProperty("服务名")
    private String serviceName;

    private String userName;

    @ApiModelProperty("账号")
    private Long accountNo;

    @ApiModelProperty("服务类型id")
    private Integer subclassId;

    @ApiModelProperty("地址")
    private String address;

    @ApiModelProperty("客户服务手机号")
    private String phone;

    @ApiModelProperty("期望上门时间")
    private Date expectArrivalTime;

    @ApiModelProperty("服务数量")
    private Integer num;

    @ApiModelProperty("订单状态：1已预约，2已派单，3进行中，4完成，5取消，6已评价")
    private Integer orderStatus;

    @ApiModelProperty("订单价格")
    private BigDecimal price;

    @ApiModelProperty("创建时间")
    private Date createTime;

}
