package com.onsiteservice.admin.controller.order.vo;

import com.onsiteservice.common.order.vo.ServiceOrderLogVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * 订单详情VO
 */
@Data
public class OrderDetailVO {

    @ApiModelProperty(value = "订单id")
    private Long id;

    @ApiModelProperty(value = "订单号")
    private String orderNo;

    @ApiModelProperty(value = "客户名")
    private String name;
    @ApiModelProperty(value = "客户手机号")
    private String phone;
    @ApiModelProperty(value = "客户下单服务地址")
    private String address;

    private Integer orderStatus;

    @ApiModelProperty(value = "期望上门时间")
    private Date expectArrivalTime;

    @ApiModelProperty(value = "服务数量")
    private Integer num;

    @ApiModelProperty(value = "子类服务图片,待受理标题图片url地址")
    private String subclassImg;

    @ApiModelProperty(value = "服务说明")
    private String demandDesc;

    private String serviceName;

    @ApiModelProperty(value = "下单备注信息")
    private String remark;

    @ApiModelProperty(value = "订单创建时间")
    private Date createTime;

    @ApiModelProperty(value = "订单修改时间")
    private Date modifyTime;

    @ApiModelProperty(value = "客户上传需求图片,最多8张")
    private List<String> demandImgUrls;

    @ApiModelProperty(value = "订单流程信息")
    private List<ServiceOrderLogVO> process;

}
