package com.onsiteservice.admin.controller.base;

import com.onsiteservice.admin.controller.base.dto.BaseErrorDTO;
import com.onsiteservice.admin.service.base.BaseErrorLogService;
import com.onsiteservice.core.result.Result;
import com.onsiteservice.dao.common.page.PageInfoVO;
import com.onsiteservice.entity.base.BaseErrorLog;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.NonNull;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;

import java.io.IOException;

import static com.onsiteservice.core.result.ResultGenerator.success;


/**
 * @author 商天翔
 * @date 2020-05-09 11:35
 * BaseErrorLogController控制类
 */
@Api(tags = "异常日志")
@RestController
@RequestMapping("/log/error")
@Validated
public class BaseErrorLogController {

    @Resource
    private BaseErrorLogService baseErrorLogService;


    @ApiOperation(value = "分页查询列表", notes = "作者: 商天翔")
    @PostMapping("/page")
    public Result<PageInfoVO> getPage(@RequestBody @NonNull @Validated BaseErrorDTO param) {
        return success(baseErrorLogService.getPage(param), "获取分页列表");
    }


}
