package com.onsiteservice;

import com.google.common.base.CaseFormat;
import com.onsiteservice.constant.constant.Constants;
import org.apache.commons.lang3.StringUtils;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;

/**
 * @author 潘维吉
 * @date 2019-08-01 10:14
 * 自定义api方法统一生成
 * 根据模型Model名称生成对应的XML、Mapper、Service、Controller各自的API方法
 */
public class ApiGenerator {

    //TODO 根据模型Model名称生成对应的XML、Mapper、Service、Controller各自的API方法 前提各个文件已生成
    public static void main(String[] args) {
        String modelName = "BaseTable"; // 模型名
        String methodName = "test"; // 方法名称
        String comments = "测试生成方法"; // 方法注释
        String returnType = "List<Map<String, Object>>"; // 方法返回类型
        String params = "Integer id,String str"; // 方法参数 支持无参 单参 多参 , 多参分号后暂不要加空格 注意格式
        String methodType = "GET"; // 方法类型 支持 GET, POST, PUT, DELETE

        System.out.println("===========================自定义API方法代码自动生成结果=================================");
        System.out.println();
        ApiGenerator.genApi(modelName, methodName, comments, returnType, params, methodType);
        System.out.println();
        System.out.println("=======================================================================================");
        System.out.println();
        System.out.println("根据" + modelName + "模型名称生成对应的XML、Mapper、Service、Controller各自的"
                + returnType + " " + methodName + "(" + params + ")" + "方法完成" + SUCCESS_COLOR);
    }

    //以下几个选项根据项目的实际情况修改
    private static final String CURRENT_MODULE_NAME = CodeGenerator.CURRENT_MODULE_NAME;//当前生成模块名称 根据项目修改
    private static final String CURRENT_PACKAGE = CodeGenerator.CURRENT_PACKAGE;//当前生成模块包名称 根据项目修改

    public static String FILE_MODULE = ""; // 自定义文件模块目录  用于生成到相应的文件夹下 默认使用表前缀
    public static final Boolean IS_GEN_FILE_MODULE = true; // 是生成文件模块目录

    private static final String CONTROLLER_PACKAGE = CURRENT_PACKAGE + ".controller";//Controller所在包
    private static final String SERVICE_PACKAGE = CURRENT_PACKAGE + ".service";//Service所在包
    private static final String MAPPER_PACKAGE = CURRENT_PACKAGE + ".mapper";//Mapper所在包

    private static final String PROJECT_PATH = System.getProperty("user.dir") + "/" + CURRENT_MODULE_NAME;//当前项目在硬盘上的基础路径

    private static final String JAVA_PATH = "/src/main/java"; //java文件路径
    private static final String RESOURCES_PATH = "/src/main/resources";//xml sql资源文件路径

    private static final String CONTROLLER_PACKAGE_PATH = packageConvertPath(CONTROLLER_PACKAGE);//生成的Controller存放路径
    private static final String SERVICE_PACKAGE_PATH = packageConvertPath(SERVICE_PACKAGE);//生成的Service接口存放路径
    private static final String MAPPER_PACKAGE_PATH = packageConvertPath(MAPPER_PACKAGE);//生成的Mapper接口存放路径

    public static final String SUCCESS_COLOR = Constants.ANSI_GREEN + " ✔ " + Constants.ANSI_RESET;
    public static final String FAIL_COLOR = Constants.ANSI_RED + " ✘ " + Constants.ANSI_RESET;

    /**
     * 统一生成API方法
     */
    public static void genApi(String modelName, String methodName, String comments, String returnType, String params, String methodType) {
        FILE_MODULE = StringUtils.isNotBlank(FILE_MODULE) ? FILE_MODULE : modelNameConvertTableName(modelName).split("_")[0];
        updateMapperAndXML(modelName, methodName, comments, returnType, params, methodType);
        updateService(modelName, methodName, comments, returnType, params);
        updateController(modelName, methodName, comments, returnType, params, methodType);
    }

    /**
     * mapper接口和 xml两处方法生成
     */
    public static void updateMapperAndXML(String modelName, String methodName, String comments, String returnType, String params, String methodType) {
        FILE_MODULE = StringUtils.isNotBlank(FILE_MODULE) ? FILE_MODULE : modelNameConvertTableName(modelName).split("_")[0];
        String sqlType = "";
        String resultType = "";
        switch (methodType) {
            case "POST":
                sqlType = "insert";
                break;
            case "PUT":
                sqlType = "update";
                break;
            case "DELETE":
                sqlType = "delete";
                break;
            default:
                sqlType = "select";
                resultType = "resultType=\"map\"";
        }

        String sqlSnippet = "";

        String note = "    /**\n" +
                "     * " + comments + "\n" +
                "     */\n";

        updateFile(PROJECT_PATH + RESOURCES_PATH + "/mapper/" + (IS_GEN_FILE_MODULE ? (FILE_MODULE + "/") : "") + modelName + "BizMapper.xml",
                "    <!--" + comments + "-->\n" +
                        "    <" + sqlType + " id=\"" + methodName + "\" " + resultType + ">\n" +
                        sqlSnippet +
                        "    \n" +
                        "    </" + sqlType + ">",
                "</mapper>", 11);
        System.out.println(modelName + "BizMapper.xml   资源XML SQL文件新增方法" + SUCCESS_COLOR);

        updateFile(PROJECT_PATH + JAVA_PATH + MAPPER_PACKAGE_PATH + (IS_GEN_FILE_MODULE ? (FILE_MODULE + "/") : "") + modelName + "BizMapper.java",
                note + "    " + returnType + " "
                        + methodName + "(" + getMapperParams(params) + ");",
                "}", 2);
        System.out.println(modelName + "BizMapper.java   Mapper接口新增方法" + SUCCESS_COLOR);
    }

    /**
     * Service层两处方法生成
     */
    public static void updateService(String modelName, String methodName, String comments, String returnType, String params) {
        String lowerModelName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, modelName);
        String note = "    /**\n" +
                "     * " + comments + "\n" +
                "     */\n";

        updateFile(PROJECT_PATH + JAVA_PATH + SERVICE_PACKAGE_PATH + (IS_GEN_FILE_MODULE ? (FILE_MODULE + "/") : "") + modelName + "Service.java",
                note +
                        // "    @Override \n" +
                        "    public " + returnType + " " + methodName + "(" + params + ") {\n" +
                        "        return " + lowerModelName + "BizMapper." + methodName + "(" + getParamsName(params) + ");\n" +
                        "    }", "}", 3);
        System.out.println(modelName + "Service.java   服务类新增方法" + SUCCESS_COLOR);
    }

    /**
     * Controller层方法生成
     */
    public static void updateController(String modelName, String methodName, String comments, String returnType, String params, String methodType) {
        String lowerModelName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, modelName);
        String requestMapping = "";
        switch (methodType) {
            case "POST":
                requestMapping = "@PostMapping";
                break;
            case "PUT":
                requestMapping = "@PutMapping";
                break;
            case "DELETE":
                requestMapping = "@DeleteMapping";
                break;
            default:
                requestMapping = "@GetMapping";
        }

        String note = "    /**\n" +
                "     * " + comments + "\n" +
                "     */\n";
        updateFile(PROJECT_PATH + JAVA_PATH + CONTROLLER_PACKAGE_PATH + (IS_GEN_FILE_MODULE ? (FILE_MODULE + "/") : "") + modelName + "Controller.java",
                note +
                        "    " + requestMapping + "(\"/" + CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_HYPHEN, methodName) + "\") \n" +
                        "    public Result " + methodName + "(" + params + ") {\n" +
                        "        " + returnType + " result = " + lowerModelName + "Service."
                        + methodName + "(" + getParamsName(params) + "); \n" +
                        "        return success(result, \"" + comments + "成功" + "\");\n" +
                        "    }", "}", 3);
        System.out.println(modelName + "Controller.java   控制类新增方法" + SUCCESS_COLOR);
    }

    /**
     * 更新文件
     *
     * @param filePathName 文件路径
     * @param content      更新的内容代码
     * @param suffix       根据修改的文件尾部后缀符号替换
     * @param tailNum      根据修改的文件截取指定的代码插入位置
     */
    public static void updateFile(String filePathName, String content, String suffix, int tailNum) {
        if (!isExistsFile(filePathName)) {
            return;
        }
        try {
            // 打开一个随机访问文件流，按读写方式
            RandomAccessFile randomFile = new RandomAccessFile(filePathName, "rw");
            // 文件长度，字节数
            long fileLength = randomFile.length() - tailNum;
            // 将写文件指针移到文件尾
            randomFile.seek(fileLength);
            // 中文乱码处理 用write(byte b[])方法
            randomFile.write(("\n" + content + "\n" + suffix).getBytes());
            randomFile.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * 获取多参数名称
     */
    private static String getParamsName(String params) {
        if (StringUtils.isBlank(params)) {
            return "";
        }
        List<String> paramsList = new ArrayList<>();
        Arrays.asList(params.split(",")).forEach(item -> {
            paramsList.add(item.split(" ")[1]);
        });
        return StringUtils.join(paramsList.toArray(), ", ");
    }

    /**
     * 获取Mapper接口多参数
     */
    private static String getMapperParams(String params) {
        if (StringUtils.isBlank(params)) {
            return "";
        }
        StringJoiner mapperParams = new StringJoiner(", ");
        Arrays.asList(params.split(",")).forEach(item -> {
            mapperParams.add("@Param(\"" + item.split(" ")[1] + "\") " + item);
        });
        return mapperParams.toString();
    }

    /**
     * 文件是否存在
     */
    private static boolean isExistsFile(String filePathName) {
        File file = new File(filePathName);
        if (!file.exists()) {  // file.isDirectory()
            // file.createNewFile();
            System.out.println("文件" + filePathName + "不存在, 无法代码生成" + FAIL_COLOR);
            return false;
        }
        return true;
    }

    /**
     * 包名转成路径
     */
    private static String packageConvertPath(String packageName) {
        return String.format("/%s/",
                packageName.contains(".") ? packageName.replaceAll("\\.", "/") : packageName);
    }

    /**
     * 大驼峰转下划线
     */
    private static String modelNameConvertTableName(String modelName) {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, modelName);
    }


}
