package com.onsiteservice.miniapp.service.worker;

import com.google.common.collect.Lists;
import com.onsiteservice.dao.common.AbstractMapper;
import com.onsiteservice.dao.mapper.service.ServiceValuatorAssignMapper;
import com.onsiteservice.dao.mapper.service.ServiceValuatorMapper;
import com.onsiteservice.entity.service.ServiceValuator;
import com.onsiteservice.entity.service.ServiceValuatorAssign;
import com.onsiteservice.miniapp.controller.worker.vo.ServiceValuatorVO;
import com.onsiteservice.miniapp.mapper.service.ServiceValuatorBizMapper;
import com.onsiteservice.util.AttrCopyUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import tk.mybatis.mapper.entity.Condition;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author 潘维吉
 * @date 2022-07-11 16:07
 * @description ServiceValuatorService服务类
 */
@Service
@Slf4j
@Transactional(rollbackFor = Exception.class)
public class ServiceValuatorService extends AbstractMapper<ServiceValuator> {


    @Resource
    private ServiceValuatorAssignMapper serviceValuatorAssignMapper;

    @Resource
    private ServiceValuatorBizMapper serviceValuatorBizMapper;


    public List<ServiceValuatorVO> all() {
        List<ServiceValuator> serviceValuatorList = this.selectAll();
        return handle(serviceValuatorList);
    }


    public List<ServiceValuatorVO> selectByName(String name) {
        log.info("valuator selectByName name: {}", name);

        List<ServiceValuator> serviceValuatorList = serviceValuatorBizMapper.selectByNameLike(name);
        return handle(serviceValuatorList);
    }


    private List<ServiceValuatorVO> handle(List<ServiceValuator> serviceValuatorList){
        if (CollectionUtils.isEmpty(serviceValuatorList)) {
            return Lists.newArrayList();
        }

        // 估价员id列表
        List<Long> valuatorIds = serviceValuatorList.parallelStream().map(ServiceValuator::getId).collect(Collectors.toList());
        // 已被指派的时间
        List<ServiceValuatorAssign> serviceValuatorAssignList = serviceValuatorAssignMapper.selectByDeletedAndIdListAndAssignTime(valuatorIds);
        Map<Long, List<ServiceValuatorAssign>> serviceValuatorAssignMap =
                serviceValuatorAssignList.parallelStream()
                        .collect(Collectors.groupingBy(ServiceValuatorAssign::getValuatorId));

        return serviceValuatorList.parallelStream().map(e1 -> {
            ServiceValuatorVO serviceValuatorVO = AttrCopyUtils.copy(e1, new ServiceValuatorVO());
            // 估价员已经被指派的时间
            List<ServiceValuatorAssign> assigns = serviceValuatorAssignMap.getOrDefault(e1.getId(), Lists.newArrayList());
            List<Date> assignTimes = assigns.parallelStream().map(ServiceValuatorAssign::getAssignTime).collect(Collectors.toList());

            serviceValuatorVO.setAssignTime(assignTimes);

            return serviceValuatorVO;
        }).collect(Collectors.toList());
    }


}
