/*
 * Copyright (c) 2015. xitai  information and technology company
 */

package com.onsiteservice.miniapp.service.weixin.pay.util;

import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by peter on 15/5/12.
 */
public class ParseXmlUtil {
	private static Logger logger = LoggerFactory.getLogger(ParseXmlUtil.class);

	/**
	 * 解析得到相应键的值
	 *
	 * @param xml，key
	 * @return
	 * @throws Exception
	 */
	public static String parseXml2KeyValue(String xml, String key) throws Exception {
		Document doc = null;
		doc = DocumentHelper.parseText(xml); // 将字符串转为XML
		Element rootElt = doc.getRootElement(); // 获取根节点
		Element keyValue = rootElt.element(key);
		String Value = keyValue.getText();
		return Value;
	}

	/***
	 * 解析xml转换成Map
	 *
	 * @param xmlStr
	 * @return
	 * @throws Exception
	 */
	public static Map<String, String> parseXml2Map(String xml) throws Exception {
		// 解析结果存储在HashMap
		Map<String, String> map = new HashMap<String, String>();
		Document reader = DocumentHelper.parseText(xml);
		// 得到xml根元素
		Element root = reader.getRootElement();
		// 得到根元素的所有子节点
		List<Element> elementList = root.elements();
		// 遍历所有子节点
		for (Element e : elementList) {
			map.put(e.getName(), e.getText());
		}
		return map;
	}
}
