package com.onsiteservice.miniapp.service.weixin.pay.util;

import java.net.URLEncoder;
import java.util.*;
import java.util.Map.Entry;

public class MapUtil {
	  
    /** 
     * 使用 Map按key进行排序 
     * @param map 
     * @return 
     */  
    public static Map<String, String> sortMapByKey(Map<String, String> map) {
        if (map == null || map.isEmpty()) {  
            return null;  
        }  
        Map<String, String> sortMap = new TreeMap<String, String>(new MapKeyComparator());
        sortMap.putAll(map);  
        return sortMap;  
    }  
    
    /**
     * 将map内的数据按key的顺序排序并拼接字符串
     * @param paraMap
     * @param urlencode
     * @return
     * @throws Exception
     */
	public static String FormatBizQueryParaMap(Map<String, String> paraMap,
                                               boolean urlencode) throws Exception {

		String buff = "";
		try {
			List<Entry<String, String>> infoIds = new ArrayList<Entry<String, String>>(paraMap.entrySet());

			Collections.sort(infoIds,
					new Comparator<Entry<String, String>>() {
						public int compare(Entry<String, String> o1,
                                           Entry<String, String> o2) {
							return (o1.getKey()).toString().compareTo(
									o2.getKey());
						}
					});

			for (int i = 0; i < infoIds.size(); i++) {
				Entry<String, String> item = infoIds.get(i);
				//System.out.println(item.getKey());
				if (item.getKey() != "") {
					
					String key = item.getKey();
					String val = item.getValue();
					if (urlencode) {
						val = URLEncoder.encode(val, "utf-8");

					}
					buff += key + "=" + val + "&";

				}
			}

			if (buff.isEmpty() == false) {
				buff = buff.substring(0, buff.length() - 1);
			}
		} catch (Exception e) {
			throw new RuntimeException(e.getMessage());
		}
		return buff;
	}
    	
    /**
     * HashMap转成xml类型的String
     * @param arr
     * @return
     */
    public static String ArrayToXml(HashMap<String, String> arr) {
		String xml = "<xml>";
		
		Iterator<Entry<String, String>> iter = arr.entrySet().iterator();
		while (iter.hasNext()) {
			Entry<String, String> entry = iter.next();
			String key = entry.getKey();
			String val = entry.getValue();
			if (IsNumeric(val)) {
				xml += "<" + key + ">" + val + "</" + key + ">";

			} else
				xml += "<" + key + "><![CDATA[" + val + "]]></" + key + ">";
		}

		xml += "</xml>";
		return xml;
	}
    
    public static boolean IsNumeric(String str) {
		if (str.matches("\\d *")) {
			return true;
		} else {
			return false;
		}
	}
  
}
