package com.onsiteservice.miniapp.service.category;

import com.github.pagehelper.PageHelper;
import com.onsiteservice.core.result.Result;
import com.onsiteservice.core.result.ResultGenerator;
import com.onsiteservice.dao.common.AbstractMapper;
import com.onsiteservice.dao.common.page.PageInfoVO;
import com.onsiteservice.entity.category.ServiceSubclass;
import com.onsiteservice.miniapp.controller.category.dto.PageServiceSubclassDTO;
import com.onsiteservice.miniapp.controller.category.vo.ServiceSubclassVO;
import com.onsiteservice.miniapp.mapper.category.ServiceSubclassBizMapper;
import com.onsiteservice.util.AttrCopyUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

@Service
@Transactional(rollbackFor = Exception.class)
public class ServiceSubclassService extends AbstractMapper<ServiceSubclass> {

    @Resource
    private ServiceSubclassBizMapper serviceSubclassBizMapper;

    public Result<PageInfoVO<ServiceSubclassVO>> getPage(PageServiceSubclassDTO dto) {
        PageHelper.startPage(dto.getPage(), dto.getSize());
        List<ServiceSubclass> serviceSubclassList = serviceSubclassBizMapper.selectServiceSubclassPage(dto);
        List<ServiceSubclassVO> serviceSubclassVOList = serviceSubclassList.parallelStream()
                .map(e -> AttrCopyUtils.copy(e, new ServiceSubclassVO())).collect(Collectors.toList());
        return ResultGenerator.success(new PageInfoVO<>(serviceSubclassVOList));
    }

}
