package com.onsiteservice.miniapp.service.category;

import com.github.pagehelper.PageHelper;
import com.onsiteservice.core.result.Result;
import com.onsiteservice.core.result.ResultGenerator;
import com.onsiteservice.dao.common.AbstractMapper;
import com.onsiteservice.dao.common.page.PageInfoVO;
import com.onsiteservice.entity.category.ServiceCategory;
import com.onsiteservice.miniapp.controller.category.dto.PageServiceCategoryDTO;
import com.onsiteservice.miniapp.controller.category.vo.ServiceCategoryVO;
import com.onsiteservice.miniapp.mapper.category.ServiceCategoryBizMapper;
import com.onsiteservice.util.AttrCopyUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

@Service
@Transactional(rollbackFor = Exception.class)
public class ServiceCategoryService extends AbstractMapper<ServiceCategory> {

    @Resource
    private ServiceCategoryBizMapper serviceCategoryBizMapper;

    /**
     * 分页查询列表
     */
    public Result<PageInfoVO<ServiceCategoryVO>> getPage(PageServiceCategoryDTO dto) {
        PageHelper.startPage(dto.getPage(), dto.getSize());
        List<ServiceCategory> serviceCategoryList = serviceCategoryBizMapper.selectServiceCategoryPage(dto);
        List<ServiceCategoryVO> serviceCategoryVOList = serviceCategoryList.parallelStream()
                .map(e -> AttrCopyUtils.copy(e, new ServiceCategoryVO())).collect(Collectors.toList());
        return ResultGenerator.success(new PageInfoVO<>(serviceCategoryVOList));
    }


}
