package com.onsiteservice.miniapp.controller.order.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.extern.log4j.Log4j2;
import org.checkerframework.checker.units.qual.A;

import javax.validation.constraints.Future;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.Date;

/**
 * <P></P>
 *
 * @author 李宁
 * @version v1.0
 * @since 2022/7/7 15:20
 */
@Data
@ApiModel("订单估价请求模型")
public class ValuationServiceOrderDTO {

    @ApiModelProperty(value = "订单id", required = true)
    @NotNull(message = "请输入订单ID")
    private Long id;

    @ApiModelProperty(value = "估价员id", required = true)
    @NotNull(message = "请选择估价员")
    private Long hostId;

    @ApiModelProperty(value = "估价备注")
    private String remark;

    @ApiModelProperty(value = "期望估价员上门时间", required = true)
    @NotNull(message = "请选择上门时间")
    @Future(message = "上门时间必须为将来的某个时间点")
    private Date expectArrivalTime;

}
