package com.onsiteservice.miniapp.controller.order.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Future;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.Date;

/**
 * <P></P>
 *
 * @author 李宁
 * @version v1.0
 * @since 2022/7/7 15:20
 */
@Data
@ApiModel("派单请求模型")
public class DispatchServiceOrderDTO {

    @ApiModelProperty(value = "订单id", required = true)
    @NotNull(message = "请选择订单")
    private Long id;

    @ApiModelProperty(value = "维修工id", required = true)
    @NotNull(message = "请选择维修工")
    private Long hostId;

    @ApiModelProperty(value = "派单备注")
    private String remark;

    @ApiModelProperty(value = "期望维修工上门时间", required = true)
    @NotNull(message = "请选择上门时间")
    @Future(message = "上门时间必须为将来的某个时间点")
    private Date expectArrivalTime;

}
