package com.onsiteservice.miniapp.controller.category;

import com.onsiteservice.core.result.Result;
import com.onsiteservice.dao.common.page.PageInfoVO;
import com.onsiteservice.dao.common.page.PageParams;
import com.onsiteservice.miniapp.controller.category.dto.PageServiceSubclassDTO;
import com.onsiteservice.miniapp.controller.category.vo.ServiceSubclassVO;
import com.onsiteservice.miniapp.service.category.ServiceSubclassService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.NonNull;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

import javax.annotation.Resource;

import static com.onsiteservice.core.result.ResultGenerator.success;

/**
 * <P>服务大类模块</P>
 *
 * @author 李宁
 * @version v1.0
 * @since 2022/7/7 08:51
 */
@Api(tags = "服务子类模块")
@RestController
@RequestMapping("/subclass/")
@Validated
public class ServiceSubclassController {

    @Resource
    private ServiceSubclassService serviceSubclassService;


    @ApiOperation(value = "分页查询列表")
    @PostMapping("page")
    public Result<PageInfoVO<ServiceSubclassVO>> getPage(@RequestBody @NonNull @Validated PageServiceSubclassDTO dto) {
        return serviceSubclassService.getPage(dto);
    }


}
