package com.onsiteservice.entity.service;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

@Getter
@Setter
@ToString
@ApiModel("订单流程日志表")
@Table(name = "service_order_log")
public class ServiceOrderLog implements Serializable {
    /**
     * 主键
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty("主键")
    private Long id;

    /**
     * 订单id
     */
    @Column(name = "order_id")
    @ApiModelProperty("订单id")
    private Long orderId;

    /**
     * 流程id <link>ServiceOrderStatusEnum</link>
     */
    @Column(name = "process_id")
    @ApiModelProperty("流程id")
    private Integer processId;

    /**
     * 维修工id或估价员id
     */
    @Column(name = "host_id")
    @ApiModelProperty("维修工id或估价员id")
    private Long hostId;

    /**
     * 步骤说明
     */
    @ApiModelProperty("步骤说明")
    private String description;

    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;

    /**
     * 创建时间
     */
    @Column(name = "create_time")
    @ApiModelProperty("创建时间")
    private Date createTime;

    private static final long serialVersionUID = 1L;
}