package com.onsiteservice.entity.pay;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

@Getter
@Setter
@ToString
@ApiModel("微信支付商户表")
@Table(name = "pay_channel_wechat")
public class PayChannelWechat implements Serializable {
    /**
     * 主键
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty("主键")
    private Long id;

    /**
     * 商户名称
     */
    @Column(name = "merchant_name")
    @ApiModelProperty("商户名称")
    private String merchantName;

    /**
     * appid
     */
    @ApiModelProperty("appid")
    private String appid;

    /**
     * 商户id
     */
    @ApiModelProperty("商户id")
    private String mchid;

    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;

    /**
     * 创建时间
     */
    @Column(name = "create_time")
    @ApiModelProperty("创建时间")
    private Date createTime;

    /**
     * 秘钥
     */
    @Column(name = "wechat_key")
    @ApiModelProperty("秘钥")
    private String wechatKey;

    /**
     * 退款证书
     */
    @Column(name = "refund_cert")
    @ApiModelProperty("退款证书")
    private byte[] refundCert;

    private static final long serialVersionUID = 1L;
}