package com.onsiteservice.entity.category;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@Getter
@Setter
@ToString
@ApiModel("服务大类表")
@Table(name = "service_category")
public class ServiceCategory implements Serializable {
    /**
     * 主键
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty("主键")
    private Integer id;

    /**
     * 服务名称
     */
    @Column(name = "service_name")
    @ApiModelProperty("服务名称")
    private String serviceName;

    @Column(name = "sequence")
    @ApiModelProperty("顺序")
    private Integer sequence;

    @Column(name = "img")
    @ApiModelProperty("大类图片")
    private String img;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    @ApiModelProperty("创建人")
    private String createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_time")
    @ApiModelProperty("创建时间")
    private Date createTime;

    /**
     * 修改人
     */
    @Column(name = "modify_by")
    @ApiModelProperty("修改人")
    private String modifyBy;

    /**
     * 修改时间
     */
    @Column(name = "modify_time")
    @ApiModelProperty("修改时间")
    private Date modifyTime;

    private static final long serialVersionUID = 1L;
}