package com.onsiteservice.dao.common.schedule;/*


import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.provider.jdbctemplate.JdbcTemplateLockProvider;
import net.javacrumbs.shedlock.spring.annotation.EnableSchedulerLock;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;

import javax.sql.DataSource;
import java.util.TimeZone;

*/
/**
 * @author 潘维吉
 * @date 2019-03-22 11:57
 * 基于ShedLock实现轻量级分布式定时锁 仅适用于具有共享数据库的环境
 * ShedLock是一个在分布式环境中使用的定时任务框架，用于解决在分布式环境中的多个实例的相同定时任务在同一时间点重复执行的问题，
 * 解决思路是通过对公用的数据库中的某个表进行记录和加锁，使得同一时间点只有第一个执行定时任务并成功在数据库表中写入相应记录的节点能够成功执行而其他节点直接跳过该任务。
 * 简单来说，ShedLock本身只做一件事情：保证一个任务最多同时执行一次。所以如官网所说的，ShedLock不是一个分布式调度器，只是一个锁
 * ShedLock创建一个数据库表，以保留有关调度程序锁的信息
 *//*

@ConditionalOnProperty(prefix = "project.schedule", name = {"enabled"}, matchIfMissing = false)
@Configuration
//作用就是在被加锁的节点挂了时，无法释放锁，造成其他节点无法进行下一任务 默认最大30s 最小1s
@EnableSchedulerLock(defaultLockAtLeastFor = "PT1S", defaultLockAtMostFor = "PT30S")
public class ShedLockConfig {

    @Bean
    public LockProvider lockProvider(DataSource dataSource) {
        return new JdbcTemplateLockProvider(
                JdbcTemplateLockProvider.Configuration.builder()
                        .withJdbcTemplate(new JdbcTemplate(dataSource))
                        .withTimeZone(TimeZone.getTimeZone("Asia/Shanghai"))
                        */
/* .withTableName("shedlock")
                        .withColumnNames(new ColumnNames("name", "lock_until", "locked_at", "locked_by"))*//*

                        //.usingDbTime() // Works on Postgres, MySQL, MariaDb, MS SQL, Oracle, DB2, HSQL and H2 锁定提供者将基于数据库服务器时间使用UTC时间
                        .build()
        );
    }
}
*/
