package com.onsiteservice.dao.common.page;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.Positive;

/**
 * @author 潘维吉
 * @date 2019-03-17 20:50
 * 分页参数统一定义和验证
 * 参数平级结构 可简化开发
 */
@ApiModel(description = "分页查询参数")
@Getter
@Setter
@ToString
public class PageParams extends SingleSort {

    /** 当前页数 默认1 */
    @ApiModelProperty(value = "当前页数 默认1", example = "1")
    @Positive(message = "必须是正整数")
    private Integer page = 1;

    /** 每页的记录数 默认10  当size=0表示不分页查询全部数据 */
    @ApiModelProperty(value = "每页的记录数 默认10  当size=0表示不分页查询全部数据", example = "10")
    // @PositiveOrZero(message = "必须是正整数或零")
    @Range(min = 0, max = 1000, message = "值在0-1000之间")
    private Integer size = 10;

}
