package com.onsiteservice.dao.common.page;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.apache.commons.lang3.StringUtils;

import javax.validation.constraints.NotBlank;
import java.util.List;
import java.util.StringJoiner;

/**
 * @author 潘维吉
 * @date 2019/10/24 15:09
 * @email 406798106@qq.com
 * @description 多字段排序类 使用 private List<MultiSort> sorts;
 * 排序参数swagger隐藏 前后端人员分离DTO重新定义具体排序说明
 */
@ApiModel(description = "多字段排序类")
@Getter
@Setter
@ToString
public class MultiSort {

    @ApiModelProperty(value = "排序字段", hidden = true)
    @NotBlank(message = "排序字段不能为空")
    private String sort;


    @ApiModelProperty(value = "排序方向 默认升序 升序asc 降序desc", hidden = true)
    @NotBlank(message = "排序方向不能为空")
    private String order;

    /**
     * 根据排序list转换成sql语句
     *
     * @param sort
     * @return sql片段
     */
    public static String getOrderBySql(List<MultiSort> sort) {
        if (sort == null) {
            return "";
        }
        StringJoiner sql = new StringJoiner(" , ");
        sort.forEach(item -> {
            sql.add(item.getSort() + " " + (StringUtils.isBlank(item.getOrder()) ? "asc" : item.getOrder()));
        });
        return sql.toString();
    }
}
