package com.onsiteservice.dao.common.map;

import com.google.common.base.CaseFormat;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.wrapper.MapWrapper;

import java.util.Map;

/**
 * @author 潘维吉
 * @date 2018-07-12
 * mybatis自定义xml 返回类型resultType="map" sql下划线字段转驼峰命名  如user_name自动转userName
 * 继承类 MapWrapper,重写findProperty,通过useCamelCase来判断是否开启使用驼峰转换
 * 配置mybatis.configuration.map-underscore-to-camel-case=true  作用于javabean的field的,并不是map
 */
public class CustomMapWrapper extends MapWrapper {

    public CustomMapWrapper(MetaObject metaObject, Map<String, Object> map) {
        super(metaObject, map);
    }

    @Override
    public String findProperty(String name, boolean useCamelCase) {
        //是否开启下划线命名转换驼峰命名 MybatisConfig 设置
        if (useCamelCase) {
            //CaseFormat是引用的 guava库里面有下划线命名转换驼峰命名
            if (name.contains("_")) { //只转换有下划线的字段
                return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, name);
            } else {
                return name;
            }
        } else {
            return name;
        }
    }

}
