package com.onsiteservice.core.security.jwt;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.AntPathMatcher;

/**
 * @author 潘维吉
 * @date 2018-07-25
 * 不认证路径配置  不认证路径单独封装解耦配置  使用Ant URL风格匹配验证
 * 注意 每个项目和模块路径都不一样  需要各自的application.yaml里单独修改配置
 * @Component自动装配Bean到IOC容器管理 用于获取application.yaml设置的非认证Ant url路径
 */
@Component
@Getter
public class JwtPathProperties {

    /** Ant URL风格匹配 忽略jwt认证路径集 */
    private static String antPaths;

    /** 基础token可访问的 Ant URL风格匹配 */
    private static String baseTokenAntPaths;

    /**
     * 请求路径是否需要认证
     * Ant URL风格匹配
     *
     * @param path 请求path路径
     */
    public static boolean isAuth(String path) {
        //Ant URL风格匹配
        if (antPaths != null) {
            for (String pattern : StringUtils.deleteWhitespace(antPaths).split(",")) {
                if (isMatcherAntPath(pattern, path)) {
                    return false;
                }
            }
        }
        return true;
    }

    /**
     * 基础token请求路径是否需要认证
     */
    public static boolean isBaseTokenCanAccess(String path) {
        //Ant URL风格匹配
        if (baseTokenAntPaths != null) {
            for (String pattern : StringUtils.deleteWhitespace(baseTokenAntPaths).split(",")) {
                if (isMatcherAntPath(pattern, path)) {
                    return true;
                }
            }
        }
        return false;
    }

    /**
     * Ant URL风格匹配
     */
    private static boolean isMatcherAntPath(String pattern, String path) {
        AntPathMatcher antPathMatcher = new AntPathMatcher();
        if (antPathMatcher.match(pattern, path)) {
            return true;
        }
        return false;
    }

    /**
     * 因为@ConfigurationProperties只会调用 非静态的set方法
     */
    @Value("${project.jwt.ant-paths:''}")
    public void setAntPaths(String antPaths) {
        JwtPathProperties.antPaths = antPaths;
    }

    /** 基础token可访问的 Ant URL风格匹配 */
    @Value("${project.jwt.base-token-ant-paths:''}")
    public void setBaseTokenAntPaths(String baseTokenAntPaths) {
        JwtPathProperties.baseTokenAntPaths = baseTokenAntPaths;
    }

}
