package com.onsiteservice.core.result.custom;

import com.onsiteservice.core.result.Result;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

/**
 * @author 潘维吉
 * @date 2020/8/17 15:13
 * @email 406798106@qq.com
 * @description 自定义扩展响应结果规范  适配更多第三方规范
 */
//@RestControllerAdvice(basePackages = {Constants.PACKAGE_NAME_GROUP})
public class CustomResultAdvice implements ResponseBodyAdvice<Object> {

    @Override
    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> aClass) {
        // 符合下面条件的 才会执行beforeBodyWrite方法
        return returnType.getParameterType().equals(Result.class) && returnType.hasMethodAnnotation(CustomResult.class);
    }

    @Override
    public Object beforeBodyWrite(Object o, MethodParameter methodParameter, MediaType mediaType,
                                  Class<? extends HttpMessageConverter<?>> aClass,
                                  ServerHttpRequest serverHttpRequest, ServerHttpResponse serverHttpResponse) {
        // 对响应返回结果规范统一处理  这里可以在CustomResult注解扩展的key适配不同的第三方Paas平台规范拉取本服务数据  服务之间双向通信更方便
        //System.out.println(JSON.toJSONString(o));
        String platform = methodParameter.getMethodAnnotation(CustomResult.class).platform();
        //System.out.println(platform);
        return o;
    }
}
