package com.onsiteservice.constant.enums;


import com.onsiteservice.constant.enums.core.BaseEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author 潘维吉
 * @date 2018-11-07
 * 一些类型、状态字段会编写成枚举类型，比如启用状态
 * Model对象修改成枚举类型 状态如 ：1 启用 0 禁用
 * 自定义TypeHandle 目的：保存数据库的时候保存的是状态码，获取数据的时候是枚举类名称
 * DO中的老用法 @ColumnType(typeHandler = StatusEnumHandler.class, jdbcType = JdbcType.TINYINT)
 * VO中 新用法直接写 handler已自动类型映射处理 private StatusEnum status;
 */
@AllArgsConstructor
@Getter
public enum StatusEnum implements BaseEnum<StatusEnum, String> {

    DISABLE(0, "禁用"),
    ENABLE(1, "启用");

    private final int code;
    private final String value;

    /**
     * 重写toString方法 用于自定义枚举返回数据和格式
     *
     * @return 自定义枚举数据
     */
    @Override
    public String toString() {
        return "{'code':" + this.code + ",'value':'" + this.value + "'}";
    }
}
