package com.onsiteservice.constant.enums;

import org.springframework.core.env.Environment;
import org.springframework.util.Assert;

/**
 * @author 潘维吉
 * @date 2019-08-14 9:18
 * 环境常量枚举类
 */
public enum EnvironmentEnum {

    //开发环境
    DEV,
    //系统集成联调测试(内测）
    SIT,
    //内部测试
    TEST,
    //用户验收测试
    UAT,
    //性能评估测试环境(压测)
    PET,
    //预生产仿真 Simulation
    SIM,
    //生产环境
    PROD;

    /**
     * 是否是开发环境
     *
     * @Autowired Environment environment;
     */
    public static boolean isDev(Environment env) {
        Assert.notNull(env, "env parameter not null.");
        return EnvironmentEnum.DEV.name().equalsIgnoreCase(env.getProperty("spring.profiles.active"));
    }

    /**
     * 是否是生产环境
     */
    public static boolean isProd(Environment env) {
        Assert.notNull(env, "env parameter not null.");
        return EnvironmentEnum.PROD.name().equalsIgnoreCase(env.getProperty("spring.profiles.active"));
    }

    @Override
    public String toString() {
        return this.name();
    }
}
