package com.onsiteservice.constant.enums;

import lombok.Getter;

/**
 * <P></P>
 *
 * @author jack
 * @version v1.0
 * @since 2022/4/11 15:42
 */
public enum BizCodeEnum {

    /**
     * 订单分组
     */
    SERVICE_ORDER_NOT_EXIST("订单不存在"),
    SERVICE_ORDER_CANNOT_VALUATION("处于非预约状态的订单不能派估价员"),
    SERVICE_ORDER_CANNOT_REVALUATION("订单未指派估价员,不能修改"),
    SERVICE_ORDER_CANNOT_SEND("订单未受理,不能发送给客户"),
    SERVICE_ORDER_CANNOT_PAY("订单未受理,暂不能支付"),
    SERVICE_ORDER_CANNOT_CANCEL("订单不能取消"),
    SERVICE_ORDER_CANNOT_REFUND("订单不能申请退款"),
    SERVICE_ORDER_CANNOT_DISPATCH("订单未支付,不能派维修工"),
    SERVICE_ORDER_CANNOT_REDISPATCH("订单未指派维修工,不能修改"),
    SERVICE_ORDER_CANNOT_FINISH("订单未派单,不能完成本次服务"),

    /**
     * 权限相关
     */
    NO_AUTH_VALUATION_ORDER("没有权限指派估价员"),
    NO_AUTH_REVALUATION_ORDER("没有权限修改估价员"),
    NO_AUTH_SEND_ORDER("没有权限发送订单"),
    NO_AUTH_DISPATCH_ORDER("没有权限派单"),
    NO_AUTH_REDISPATCH_ORDER("没有权限修改派单"),
    NO_AUTH_FINISH_ORDER("没有权限完成服务"),
    NO_AUTH("无操作权限"),

    /**
     * 维修工模块
     */
    SERVICE_WORKER_NOT_EXIST("维修工不存在"),
    SERVICE_WORKER_HAS_EXIST("该手机号对应工作人员已存在"),

    /**
     * 估价员模块
     */
    SERVICE_VALUATOR_NOT_EXIST("估价员不存在"),
    SERVICE_VALUATOR_HAS_EXIST("该手机号对应估价员已存在"),

    /**
     * 区域分组
     */
    SERVICE_AREA_NOT_EXIST("区域不存在"),

    /**
     * 服务地址模块
     */
    SERVICE_ADDRESS_NOT_EXIST("服务地址不存在"),

    /**
     * 服务子类
     */
    SERVICE_SUBCLASS_NOT_EXIST("服务项目不存在");

    @Getter
    private String msg;

    private BizCodeEnum(String msg){
        this.msg = msg;
    }

}
