package com.onsiteservice.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;

/**
 * @author 潘维吉
 * @date 2018-05-20
 * 随机数相关工具类
 */
public class RandomUtils {

    public static final String ALL_CHAR = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";

    public static final String BIG_CHAR = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";

    public static final String LETTER_CHAR = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";

    /**
     * 返回一个定长的随机字符串(只包含大小写字母、数字)
     *
     * @param length 随机字符串长度
     * @return 随机字符串
     */
    public static String generateString(int length) {
        StringBuilder sb = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < length; i++) {
            sb.append(BIG_CHAR.charAt(random.nextInt(BIG_CHAR.length())));
        }
        return sb.toString();
    }

    /**
     * 返回一个定长的随机纯字母字符串(包含大小写字母)
     *
     * @param length 随机字符串长度
     * @return 随机字符串
     */
    public static String generateMixString(int length) {
        StringBuffer sb = new StringBuffer();
        Random random = new Random();
        for (int i = 0; i < length; i++) {
            sb.append(ALL_CHAR.charAt(random.nextInt(LETTER_CHAR.length())));
        }
        return sb.toString();
    }

    /**
     * 返回一个定长的随机纯大写字母字符串
     *
     * @param length 随机字符串长度
     * @return 随机字符串
     */
    public static String generateLowerString(int length) {
        return generateMixString(length).toLowerCase();
    }

    /**
     * 返回一个定长的随机纯小写字母字符串
     *
     * @param length 随机字符串长度
     * @return 随机字符串
     */
    public static String generateUpperString(int length) {
        return generateMixString(length).toUpperCase();
    }

    /**
     * 获取6位纯数字
     */
    public static Integer generateNum() {
        return (int) ((Math.random() * 9 + 1) * 100000);
    }

    /**
     * 获取固定长度随机数
     *
     * 2022-06-22 有BUG！，长度7位以上不要用！！
     * TODO 谁有时间给改了吧
     */
    public static String generateNum(int length) {
        Random rm = new Random();
        // 获得随机数
        double pross = (1 + rm.nextDouble()) * Math.pow(10, length);
        // 将获得的获得随机数转化为字符串
        String fixLengthString = String.valueOf(pross);
        // 返回固定的长度的随机数
        return fixLengthString.substring(1, length + 1);
    }

    /**
     * 获取范围之间的数字
     */
    public static Integer generateNumBetween(int max, int min) {
        Random random = new Random();
        return random.nextInt(max) % (max - min + 1) + min;
    }

    /**
     * 订单号
     * 年月日时分秒微秒(17位)+随机码(5位) 共22位数
     */
    public static String orderNum() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        return sdf.format(new Date()) + generateNum(5);
    }


    public static void main(String[] args) {
        System.out.println(orderNum());
    }
}
