package com.onsiteservice.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * @author 潘维吉
 * @date 2019/11/21 16:15
 * @email 406798106@qq.com
 * @description 判断包装类数组/集合为空的工具类
 */
public class ArrayUtils {

    /**
     * 判断集合是否为空
     */
    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    /**
     * 判断List是否为空
     */
    public static boolean isEmpty(List<Object> list) {
        return list == null || list.size() == 0;
    }

    /**
     * 判断List非空
     */
    public static boolean isNotEmpty(List list) {
        return list != null && list.size() > 0;
    }

    /**
     * 判断Map是否为空
     */
    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    /**
     * 判断数组是否为空
     */
    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

}
