package com.onsiteservice.common.socket;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;

import javax.annotation.Resource;

/**
 * @author 潘维吉
 * @date 2018-07-05
 * WebSocket配置类
 */
//注解@ConditionalOnProperty能够控制某个configuration是否生效
@ConditionalOnProperty(prefix = "project.websocket", name = {"enabled"}, matchIfMissing = false)
@Configuration
@EnableWebSocket
//@EnableWebSocketMessageBroker //开启STOMP协议 控制器支持@MessageMapping注解接收数据 就像使用@RequestMapping一样
public class SocketConfig implements WebSocketConfigurer {

    @Resource
    private SocketHandler webSocketHandler;
    @Resource
    private SocketInterceptor webSocketInterceptor;

    /**
     * 实现 WebSocketConfigurer 接口，重写 registerWebSocketHandlers 方法，
     * 核心实现方法，配置 websocket 入口，允许访问的域、注册 Handler、SockJs 支持和拦截器
     */
    @Override
    public void registerWebSocketHandlers(WebSocketHandlerRegistry registry) {
        //客户端与服务器端建立连接的点 允许跨域  是否允许使用SockJS协议
        // registry.addHandler()注册和路由的功能，客户端发起 websocket 连接，把 /path 交给对应的 handler 处理，而不实现具体的业务逻辑，可以理解为收集和任务分发中心。
        registry.addHandler(webSocketHandler, "/websocket")
                //addInterceptors为 handler 添加拦截器，可以在调用 handler 前后加入我们自己的逻辑代码
                .addInterceptors(webSocketInterceptor)
                // setAllowedOrigins(String[] domains),允许指定的域名或 IP (含端口号)建立长连接，不限时使用”*”号，如果指定了域名，则必须要以 http 或 https 开头
                .setAllowedOrigins("*");

        // 当浏览器不支持WebSocket，使用SockJs支持
        registry.addHandler(webSocketHandler, "/sockjs-websocket")
                .addInterceptors(webSocketInterceptor)
                .setAllowedOrigins("*")
                .withSockJS();
    }

/*    @Bean
    public ServletServerContainerFactoryBean createWebSocketContainer() {
        ServletServerContainerFactoryBean container = new ServletServerContainerFactoryBean();
        container.setMaxTextMessageBufferSize(8192*4);
        container.setMaxBinaryMessageBufferSize(8192*4);
        return container;
    }*/
}
