package com.onsiteservice.common.config;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.session.data.redis.config.annotation.web.http.EnableRedisHttpSession;

/**
 * @author 潘维吉
 * @date 2021/1/7 12:57
 * @email 406798106@qq.com
 * @description session分布式共享配置
 */
@Configuration
@ConditionalOnProperty(prefix = "project.session-shared", name = {"enabled"}, matchIfMissing = true)
@EnableRedisHttpSession(maxInactiveIntervalInSeconds = 1800)
public class SessionConfig {
}
