package com.onsiteservice.common.annotation.validation;


import java.lang.annotation.*;

/**
 * 仅用于简单情况下的重复校验
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD})
@Documented
public @interface Unique {
    /**
     * 要校验的字段
     */
    String[] field();

    /**
     * 条件字段，会使用等于作为条件
     */
    String[] conditionFields() default {};

    /**
     * 查出重复后的提示消息
     */
    String[] message() default "数据已存在";

}
