package com.onsiteservice.common.annotation.validation;

import javax.validation.Constraint;
import javax.validation.Payload;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.PARAMETER;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * @author 潘维吉
 * @date 2019-01-02 11:47
 * 自定义验证注解
 * @Constraint 指明校验逻辑的类
 */
@Documented
@Target({FIELD, PARAMETER})
@Retention(RUNTIME)
@Constraint(validatedBy = DateTimeValidator.class)
public @interface DateTime {

    /**
     * 错误消息
     *
     * @return 默认错误消息
     */
    String message() default "时间格式错误";

    /**
     * 时间格式
     *
     * @return 验证的日期格式
     */
    String format() default "yyyy-MM-dd";

    /**
     * 允许我们为约束指定验证组
     *
     * @return 分组
     */
    Class<?>[] groups() default {};

    /**
     * payload
     *
     * @return
     */
    Class<? extends Payload>[] payload() default {};
}
