package com.onsiteservice.admin.service.sys;

import com.onsiteservice.dao.common.AbstractMapper;
import com.onsiteservice.dao.mapper.sys.SysBusinessOperateMapper;
import com.onsiteservice.entity.sys.SysBusinessOperate;
import org.springframework.data.annotation.Transient;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;

/**
 * @author wangning
 * @date 2019-10-11 09:02
 * SysBusinessOperateService服务类
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class SysBusinessOperateService extends AbstractMapper<SysBusinessOperate> {

    @Resource
    private SysBusinessOperateMapper sysBusinessOperateMapper;

    @Resource
    private SysBusinessOperateResourceService sysBusinessOperateResourceService;

    @Resource
    private SysRoleOperateService sysRoleOperateService;


    public List<SysBusinessOperate> getByBusinessId(Long id) {
        SysBusinessOperate condition = new SysBusinessOperate();
        condition.setBusinessId(id);
        return sysBusinessOperateMapper.select(condition);
    }


    @Transient
    public void deleteBatch(List<Long> ids) {
        sysBusinessOperateMapper.deleteByIdList(ids);
        sysBusinessOperateResourceService.delByOperates(ids);
        sysRoleOperateService.delByOperates(ids);
    }
}
