package com.onsiteservice.admin.service.category;

import com.onsiteservice.dao.common.AbstractMapper;
import com.onsiteservice.dao.util.EntityUtils;
import com.onsiteservice.entity.category.ServiceSubclass;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * @author 商天翔
 * @date 2022-07-13 17:03
 * @description ServiceSubclassService服务类
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class ServiceSubclassService extends AbstractMapper<ServiceSubclass> {

    /**
     * 保存或更新方法
     */
    public int saveOrUpdate(ServiceSubclass serviceSubclass, Long currentUserId) {
        if (serviceSubclass.getId() == null) {
            EntityUtils.insert(serviceSubclass, currentUserId);
            return this.insertSelective(serviceSubclass);
        } else {
            EntityUtils.update(serviceSubclass, currentUserId);
            return this.updateByPrimaryKeySelective(serviceSubclass);
        }
    }


}
