package com.onsiteservice.admin.service.base;

import com.github.pagehelper.PageHelper;
import com.onsiteservice.admin.mapper.base.BaseErrorLogBizMapper;
import com.onsiteservice.dao.common.AbstractMapper;
import com.onsiteservice.dao.common.page.PageInfoVO;
import com.onsiteservice.dao.common.page.PageParams;
import com.onsiteservice.entity.base.BaseErrorLog;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

/**
 * @author 商天翔
 * @date 2020-05-09 11:35
 * BaseErrorLogService服务类
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class BaseErrorLogService extends AbstractMapper<BaseErrorLog> {

    @Resource
    private BaseErrorLogBizMapper baseErrorLogBizMapper;

    /**
     * 分页查询列表
     */
    public PageInfoVO getPage(PageParams param) {
        PageHelper.startPage(param.getPage(), param.getSize());
        return new PageInfoVO(baseErrorLogBizMapper.getPage(param));
    }

}
