package com.onsiteservice.admin.security.handler;

import com.onsiteservice.core.config.MvcConfig;
import com.onsiteservice.core.result.Result;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import static com.onsiteservice.core.result.ResultGenerator.failCustom;
import static org.springframework.http.HttpStatus.UNAUTHORIZED;

/**
 * @author 潘维吉
 * @date 2020/3/5 16:22
 * @email 406798106@qq.com
 * @description 未通过认证的用户请求受保护资源时调用 用来解决匿名用户访问无权限资源时的异常
 * 当未登录或者token失效访问接口时，自定义的返回结果
 */
@Component
public class CustomAuthenticationEntryPoint implements AuthenticationEntryPoint {

    @Override
    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) {
        //  当用户试图在不提供任何凭据的情况下访问受保护的REST资源时，将调用此方法
        //  我们应该发送一个未经认证的401响应，因为没有“登录页面”可以重定向到
        Result result = failCustom(UNAUTHORIZED.value(), "没有访问权限");
        MvcConfig.responseResult(response, result);
    }

}
