package com.onsiteservice.admin.listener;

import com.onsiteservice.common.socket.SocketHandler;
import com.onsiteservice.constant.constant.SysConstants;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.TextMessage;

import javax.annotation.Resource;

/**
 * 管理端事件通知
 */
@Component
@RabbitListener(queuesToDeclare = @Queue(SysConstants.Queue.ADMIN_ORDER))
public class OrderListener {

    @Resource
    private SocketHandler socketHandler;

    @RabbitHandler
    public void notice(Integer type) {
        socketHandler.sendMessageToAll(new TextMessage("有新订单"));
    }

}
