package com.onsiteservice.admin.controller.sys;

import com.onsiteservice.admin.service.sys.SysUserRoleService;
import com.onsiteservice.core.result.Result;
import com.onsiteservice.dao.common.page.PageInfoVO;
import com.onsiteservice.dao.common.page.PageParams;
import com.onsiteservice.entity.sys.SysUserRole;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.NonNull;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import javax.annotation.Resource;
import javax.validation.constraints.Positive;

import static com.onsiteservice.core.result.ResultGenerator.success;

/**
 * @author wang jianguo
 * @date 2021-07-22 17:53
 * SysUserRoleController控制类
 */
@ApiIgnore
@Api(tags = "SysUserRoleController")
@RestController
@RequestMapping("/sys/user/role")
@Validated
public class SysUserRoleController {

    @Resource
    private SysUserRoleService sysUserRoleService;


    @ApiOperation(value = "分页查询列表", notes = "作者: wang jianguo")
    @PostMapping("/page")
    public Result<PageInfoVO> getPage(@RequestBody @NonNull @Validated PageParams param) {
        return success(sysUserRoleService.getPage(param), "获取分页列表");
    }

    @ApiOperation(value = "根据id查询", notes = "作者: wang jianguo")
    @GetMapping("/{id}")
    public Result<SysUserRole> getDetails(@PathVariable @Positive Long id) {
        return success(sysUserRoleService.selectByPrimaryKey(id), "根据id获取详情");
    }

    @ApiOperation(value = "新增或修改", notes = "作者: wang jianguo")
    @PostMapping("/save-or-update")
    public Result saveOrUpdate(@RequestBody @NonNull @Validated SysUserRole sysUserRole) {
        return success(sysUserRoleService.saveOrUpdate(sysUserRole), sysUserRole.getId() == null ? "新增成功" : "修改成功");
    }

    @ApiOperation(value = "根据id删除", notes = "作者: wang jianguo")
    @DeleteMapping("/{id}")
    public Result deleteById(@PathVariable @Positive Long id) {
        return success(sysUserRoleService.deleteByPrimaryKey(id), "删除成功");
    }

}
