package com.onsiteservice.admin.controller.sys;

import com.github.pagehelper.PageHelper;
import com.onsiteservice.admin.controller.sys.dto.PwdChangeDTO;
import com.onsiteservice.admin.controller.sys.dto.SysUserDetailDTO;
import com.onsiteservice.admin.controller.sys.dto.SysUserPageDTO;
import com.onsiteservice.admin.service.sys.SysUserService;
import com.onsiteservice.common.annotation.user.CurrentUserId;
import com.onsiteservice.core.result.Result;
import com.onsiteservice.core.result.ResultGenerator;
import com.onsiteservice.dao.common.page.PageInfoVO;
import com.onsiteservice.entity.sys.SysUser;
import lombok.NonNull;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.validation.constraints.Positive;
import java.util.List;

/**
 * @author wangning
 * @date 2019-10-11 09:02
 * SysUserController控制类
 */
@RestController
@RequestMapping("/sys/user")
@Validated
public class SysUserController {

    @Resource
    private SysUserService sysUserService;

    /**
     * 分页查询列表
     *
     * @param dto 分页参数
     * @return 分页数据
     */
    @PostMapping("/page")
    public Result getPageList(@RequestBody SysUserPageDTO dto) {
        PageHelper.startPage(dto.getPage(), dto.getSize());
        List<SysUser> list = sysUserService.getPage(dto);
        PageInfoVO pageInfo = new PageInfoVO(list);
        return ResultGenerator.success(pageInfo, "获取分页列表");
    }

    /**
     * 根据id查询
     *
     * @param id 主键
     * @return 详情数据
     */
    @GetMapping("/{id}")
    public Result findById(@PathVariable Integer id) {
        return ResultGenerator.success(sysUserService.getUserDetail(id), "根据id获取详情");
    }

    /**
     * 新增保存对象
     *
     * @param sysUser 保存对象
     */
    @PostMapping
    public Result save(@RequestBody @NonNull @Validated SysUserDetailDTO sysUser, @CurrentUserId Long userId) {
        return ResultGenerator.success(sysUserService.saveDetail(sysUser,userId), "保存成功");
    }

    /**
     * 更新修改对象
     *
     * @param sysUser 修改对象
     */
    @PutMapping
    public Result update(@RequestBody @NonNull @Validated SysUser sysUser) {
        // 使用缓存方法
        sysUserService.saveCache(sysUser);
        return ResultGenerator.success(sysUser, "更新成功");
    }

    @GetMapping("/password/reset/{id}")
    public Result resetPwd(@PathVariable @Positive Integer id) {
        sysUserService.resetPwd(id);
        return ResultGenerator.success("重置密码成功");
    }

    @PutMapping("/password/edit")
    public Result editPwd(@RequestBody @NonNull @Validated PwdChangeDTO dto, @CurrentUserId Long userId) {
        sysUserService.editPwd(dto, userId);
        return ResultGenerator.success("修改密码成功");
    }

    @GetMapping("/change/status/{id}")
    public Result changeOnline(@PathVariable Long id) {
        return ResultGenerator.success(sysUserService.changeStatus(id), "修改使用状态");
    }
}
