package com.onsiteservice.admin.controller.sys;

import com.github.pagehelper.PageHelper;
import com.onsiteservice.admin.controller.sys.dto.SysParamDTO;
import com.onsiteservice.admin.controller.sys.vo.SysParamVO;
import com.onsiteservice.admin.service.sys.SysParamService;
import com.onsiteservice.common.annotation.user.CurrentUserId;
import com.onsiteservice.core.result.Result;
import com.onsiteservice.core.result.ResultGenerator;
import com.onsiteservice.dao.common.page.PageInfoVO;
import com.onsiteservice.entity.sys.SysParam;
import io.swagger.annotations.Api;
import lombok.NonNull;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import javax.annotation.Resource;
import javax.validation.constraints.Positive;
import java.util.List;

/**
 * @author wang jianguo
 * @date 2021-07-23 17:45
 * SysParamController控制类
 */
@ApiIgnore
@Api(tags = "SysParamController")
@RestController
@RequestMapping("/sys/param")
@Validated
public class SysParamController {

    @Resource
    private SysParamService sysParamService;


    /**
     * 分页查询总控系统参数列表
     *
     * @param sysParamDTO
     * @return
     */
    @PostMapping("/getPage")
    public Result pageList(@RequestBody SysParamDTO sysParamDTO) {
        PageHelper.startPage(sysParamDTO.getPage(), sysParamDTO.getSize());
        List<SysParamVO> list = sysParamService.queryForPage(sysParamDTO);
        PageInfoVO pageInfo = new PageInfoVO(list);
        return ResultGenerator.success(pageInfo, "获取分页列表");
    }

    /**
     * 根据id查询
     *
     * @param id 主键
     * @return 详情数据
     */
    @GetMapping("/{id}")
    public Result findById(@PathVariable @Positive Integer id) {
        SysParam sysParam = sysParamService.selectByPrimaryKey(id);
        return ResultGenerator.success(sysParam, "根据id获取详情");
    }

    /**
     * 更新修改对象
     *
     * @param sysParam 修改对象
     */
    @PutMapping
    public Result update(@RequestBody @NonNull @Validated SysParam sysParam, @CurrentUserId Long userId) {
        sysParamService.updateParam(sysParam, userId);
        return ResultGenerator.success(sysParam, "更新成功");
    }

    /**
     * 根据id删除
     *
     * @param id 主键
     */
    @DeleteMapping("/{id}")
    public Result deleteById(@PathVariable @Positive Integer id) {
        sysParamService.deleteByPrimaryKey(id);
        return ResultGenerator.success("删除成功");
    }

}
