package com.onsiteservice.admin.controller.sys;

import com.github.pagehelper.PageHelper;
import com.onsiteservice.admin.controller.sys.dto.SysDictPageDTO;
import com.onsiteservice.admin.controller.sys.dto.SysDictSaveDTO;
import com.onsiteservice.admin.service.sys.SysDictTypeService;
import com.onsiteservice.common.annotation.user.CurrentUserId;
import com.onsiteservice.core.result.Result;
import com.onsiteservice.core.result.ResultGenerator;
import com.onsiteservice.dao.common.page.PageInfoVO;
import com.onsiteservice.entity.sys.SysDictType;
import io.swagger.annotations.Api;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author wang jianguo
 * @date 2021-07-23 10:37
 * SysDictTypeController控制类
 */
@ApiIgnore
@Api(tags = "SysDictTypeController")
@RestController
@RequestMapping("/sys/dict/type")
@Validated
public class SysDictTypeController {

    @Resource
    private SysDictTypeService sysDictTypeService;


    /**
     * 分页查询列表
     *
     * @param param 分页参数
     * @return 分页数据
     */
    @PostMapping("/page")
    public Result pageList(@RequestBody SysDictPageDTO param) {
        PageHelper.startPage(param.getPage(), param.getSize());
        List<SysDictType> list = sysDictTypeService.getPage(param);
        PageInfoVO pageInfo = new PageInfoVO(list);
        return ResultGenerator.success(pageInfo, "获取分页列表");
    }

    /**
     * 根据id查询
     *
     * @param id 主键
     * @return 详情数据
     */
    @GetMapping("/{id}")
    public Result findById(@PathVariable Integer id) {
        return ResultGenerator.success(sysDictTypeService.getDetail(id), "根据id获取详情");
    }

    /**
     * 保存对象
     *
     * @param param 保存对象
     */
    @PostMapping
    public Result save(@RequestBody SysDictSaveDTO param, @CurrentUserId Long userId) {
        return ResultGenerator.success(sysDictTypeService.saveCode(param, userId), "保存通用代码");
    }

    /**
     * 根据code删除
     *
     * @param code
     */
    @DeleteMapping("/{code}")
    public Result deleteByCode(@PathVariable String code) {
        sysDictTypeService.deleteByCodes(code);
        return ResultGenerator.success("删除成功");
    }

    @RequestMapping(value = "/batchDelete", method = RequestMethod.POST)
    public Result deleteBatch(@RequestBody String[] codes) {
        sysDictTypeService.deleteByCodes(codes);
        return ResultGenerator.success("批量删除");
    }
}
