package com.onsiteservice.admin.controller.service.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Pattern;

/**
 * <P></P>
 *
 * @author 李宁
 * @version v1.0
 * @since 2022/7/11 17:19
 */
@ApiModel("添加估价员请求模型")
@Data
public class SaveServiceValuatorDTO {

    @ApiModelProperty("姓名")
    @NotBlank(message = "请输入估价员姓名")
    private String name;

    /**
     * 手机号
     */
    @ApiModelProperty("手机号")
    @NotBlank(message = "请输入估价员手机")
    @Pattern(regexp = "^1[3456789]\\d{9}$", message = "手机号格式不正确")
    private String phone;

}
