package com.onsiteservice.admin.controller.service;

import com.onsiteservice.admin.controller.service.dto.PageServiceValuatorDTO;
import com.onsiteservice.admin.controller.service.dto.SaveServiceValuatorDTO;
import com.onsiteservice.admin.controller.service.dto.UpdateServiceValuatorDTO;
import com.onsiteservice.admin.controller.service.vo.ServiceValuatorVO;
import com.onsiteservice.admin.service.service.ServiceValuatorService;
import com.onsiteservice.common.annotation.user.CurrentUserId;
import com.onsiteservice.core.result.Result;
import com.onsiteservice.dao.common.page.PageInfoVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.NonNull;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.validation.constraints.Positive;

import static com.onsiteservice.core.result.ResultGenerator.fail;
import static com.onsiteservice.core.result.ResultGenerator.success;

/**
 * <P>估价员模块</P>
 *
 * @author 李宁
 * @version v1.0
 * @since 2022/7/11 08:51
 */
@Api(tags = "估价员模块")
@RestController
@RequestMapping("/valuator/")
@Validated
public class ServiceValuatorController {

    @Resource
    private ServiceValuatorService serviceValuatorService;


    @ApiOperation(value = "分页查询列表")
    @PostMapping("page")
    public Result<PageInfoVO<ServiceValuatorVO>> getPage(@RequestBody @NonNull @Validated PageServiceValuatorDTO dto) {
        return serviceValuatorService.getPage(dto);
    }

    @ApiOperation(value = "根据id查询")
    @GetMapping("get/{id}")
    public Result<ServiceValuatorVO> getDetails(@ApiParam(name = "id", value = "估价员id") @PathVariable @Positive Long id) {
        return success(serviceValuatorService.selectById(id));
    }

    @ApiOperation(value = "新增")
    @PostMapping("save")
    public Result save(@RequestBody @NonNull @Validated SaveServiceValuatorDTO dto, @CurrentUserId Long userId) {
        return serviceValuatorService.save(dto, userId) == 1 ? success() : fail("新增失败");
    }

    @ApiOperation(value = "修改")
    @PutMapping("update")
    public Result update(@RequestBody @NonNull @Validated UpdateServiceValuatorDTO dto, @CurrentUserId Long userId) {
        return serviceValuatorService.update(dto, userId) == 1 ? success() : fail("修改失败");
    }

    @ApiOperation(value = "根据id删除")
    @DeleteMapping("/{id}")
    public Result deleteById(@ApiParam(name = "id", value = "估价员id") @PathVariable @Positive Long id, @CurrentUserId Long userId) {
        return serviceValuatorService.delete(id, userId) == 1 ? success() : fail("删除失败");
    }

}
