package com.onsiteservice.admin.controller.category;

import com.onsiteservice.admin.controller.category.dto.ServiceCategoryDTO;
import com.onsiteservice.admin.controller.category.vo.CategoryVO;
import com.onsiteservice.admin.service.category.ServiceCategoryService;
import com.onsiteservice.admin.service.category.ServiceSubclassService;
import com.onsiteservice.common.annotation.user.CurrentUserId;
import com.onsiteservice.core.result.Result;
import com.onsiteservice.entity.category.ServiceCategory;
import com.onsiteservice.entity.category.ServiceSubclass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import javax.validation.constraints.Positive;
import java.util.List;

import static com.onsiteservice.core.result.ResultGenerator.success;

/**
 * @author 商天翔
 * @date 2022-07-13 17:03
 * @description ServiceCategoryController控制类
 */
@ApiIgnore
@Api(tags = "ServiceCategoryController")
@RestController
@RequestMapping("/service")
@Validated
@AllArgsConstructor(onConstructor_ = {@Autowired})
public class ServiceCategoryController {

    private ServiceCategoryService serviceCategoryService;
    private ServiceSubclassService serviceSubclassService;


    @ApiOperation(value = "分类列表查询", notes = "作者: 商天翔")
    @PostMapping("/category-list")
    public Result<List<CategoryVO>> getCategoryList(@RequestBody ServiceCategoryDTO dto) {
        return success(serviceCategoryService.getCategoryList(dto));
    }

    @ApiOperation(value = "根据id查询大类", notes = "作者: 商天翔")
    @GetMapping("/{id}")
    public Result<ServiceCategory> getDetails(@PathVariable @Positive Long id) {
        return success(serviceCategoryService.selectByPrimaryKey(id), "根据id获取详情");
    }

    @ApiOperation(value = "根据id查询小类", notes = "作者: 商天翔")
    @GetMapping("/sub-class/{id}")
    public Result<ServiceSubclass> getSubDetails(@PathVariable @Positive Long id) {
        return success(serviceSubclassService.selectByPrimaryKey(id), "根据id获取详情");
    }

    @ApiOperation(value = "修改大类信息", notes = "作者: 商天翔")
    @PostMapping("/category")
    public Result updateCategory(@RequestBody @NonNull @Validated ServiceCategory serviceCategory,
                               @CurrentUserId Long userId) {
        return success(serviceCategoryService.saveOrUpdate(serviceCategory, userId));
    }

    @ApiOperation(value = "新增或修改小类信息", notes = "作者: 商天翔")
    @PostMapping("/subclass")
    public Result saveOrUpdateSubClass(@RequestBody @NonNull @Validated ServiceSubclass subclass,
                               @CurrentUserId Long userId) {
        return success(serviceSubclassService.saveOrUpdate(subclass, userId));
    }
}
